import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import colors from '@rocket.chat/fuselage-tokens/colors.json';
import { List, DarkModeProvider } from '@rocket.chat/layout';
import { useMemo } from 'react';
import { renderToStaticMarkup } from 'react-dom/server';
import { useTranslation } from 'react-i18next';
import PlanFeatureIcon from '../../common/PlanFeatureIcon';
var Description = function () {
    var isDarkMode = DarkModeProvider.useDarkMode();
    var color = isDarkMode ? colors.white : colors.n900;
    var t = useTranslation().t;
    var icon = useMemo(function () {
        return encodeURIComponent(renderToStaticMarkup(_jsx(PlanFeatureIcon, { color: color })));
    }, [color]);
    return (_jsx(_Fragment, { children: _jsxs(List, { color: color, spacing: 'x16', icon: icon, children: [_jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.availability') }), _jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.auditing') }), _jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.numberOfIntegrations') }), _jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.ldap') }), _jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.omnichannel') }), _jsx(List.Item, { fontScale: 'h4', children: t('page.cloudDescription.push') })] }) }));
};
export default Description;
//# sourceMappingURL=Description.js.map