"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PdfWorker = void 0;
const ChatTranscript_1 = require("./strategies/ChatTranscript");
class PdfWorker {
    constructor(mode) {
        this.mode = mode;
        this.validMimeTypes = ['image/jpeg', 'image/png', 'image/jpg'];
        if (!mode) {
            throw new Error('Invalid mode');
        }
        this.mode = mode;
        this.worker = this.getWorkerClass();
    }
    getWorkerClass() {
        switch (this.mode) {
            case 'chat-transcript':
                return new ChatTranscript_1.ChatTranscript();
            default:
                throw new Error('Invalid mode');
        }
    }
    isMimeTypeValid(mimeType) {
        if (!mimeType) {
            return false;
        }
        return this.validMimeTypes.includes(mimeType?.toLowerCase());
    }
    async renderToStream({ data, i18n }) {
        const parsedData = this.worker.parseTemplateData(data, i18n);
        return this.worker.renderTemplate(parsedData);
    }
}
exports.PdfWorker = PdfWorker;
//# sourceMappingURL=index.js.map