"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Files = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const buffer_1 = require("buffer");
const renderer_1 = require("@react-pdf/renderer");
const colors_json_1 = __importDefault(require("@rocket.chat/fuselage-tokens/colors.json"));
const typography_json_1 = require("@rocket.chat/fuselage-tokens/typography.json");
const styles = renderer_1.StyleSheet.create({
    file: {
        color: colors_json_1.default.n700,
        marginTop: 4,
        flexDirection: 'column',
        fontSize: typography_json_1.fontScales.c1.fontSize,
    },
    image: {
        width: 400,
        maxHeight: 240,
        objectFit: 'contain',
        objectPosition: '0',
    },
    invalidMessage: {
        backgroundColor: colors_json_1.default.n100,
        textAlign: 'center',
        borderColor: colors_json_1.default.n250,
        borderWidth: 1,
        borderRadius: 4,
        paddingVertical: 8,
        marginTop: 4,
    },
});
const Files = ({ files, invalidMessage }) => ((0, jsx_runtime_1.jsx)(renderer_1.View, { wrap: false, children: files?.map((file, index) => ((0, jsx_runtime_1.jsxs)(renderer_1.View, { style: styles.file, children: [(0, jsx_runtime_1.jsx)(renderer_1.Text, { children: file.name }), file.buffer ? (
            // Cache = false is required to avoid a bug in react-pdf
            // Which causes the image to be duplicated when using buffers because of bad caching
            // https://github.com/diegomura/react-pdf/issues/1805
            (0, jsx_runtime_1.jsx)(renderer_1.Image, { style: styles.image, src: buffer_1.Buffer.from(file.buffer), cache: false })) : ((0, jsx_runtime_1.jsx)(renderer_1.Text, { style: styles.invalidMessage, children: invalidMessage }))] }, index))) }));
exports.Files = Files;
//# sourceMappingURL=Files.js.map