"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Header = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const colors_json_1 = __importDefault(require("@rocket.chat/fuselage-tokens/colors.json"));
const typography_json_1 = require("@rocket.chat/fuselage-tokens/typography.json");
const styles = renderer_1.StyleSheet.create({
    header: {
        padding: 32,
        borderRadius: 4,
        backgroundColor: colors_json_1.default.n100,
        marginBottom: 16,
    },
    headerText: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        borderBottomColor: colors_json_1.default.n200,
        borderBottomWidth: 2,
        marginBottom: 16,
        paddingBottom: 16,
        color: colors_json_1.default.n900,
    },
    pagination: {
        fontSize: typography_json_1.fontScales.c1.fontSize,
        color: colors_json_1.default.n700,
    },
    title: {
        fontSize: typography_json_1.fontScales.h4.fontSize,
        fontWeight: typography_json_1.fontScales.h4.fontWeight,
    },
    subtitle: {
        fontSize: typography_json_1.fontScales.p2m.fontSize,
        fontWeight: typography_json_1.fontScales.p2m.fontWeight,
        color: colors_json_1.default.n900,
    },
    container: {
        fontSize: typography_json_1.fontScales.c1.fontSize,
        flexDirection: 'row',
        flexWrap: 'wrap',
    },
    item: {
        paddingTop: 8,
        paddingRight: 10,
        flexGrow: 1,
        flexShrink: 1,
        width: '50%',
    },
    key: {
        fontWeight: typography_json_1.fontScales.c2.fontWeight,
    },
});
const Header = ({ title, subtitle, values }) => ((0, jsx_runtime_1.jsxs)(renderer_1.View, { style: styles.header, fixed: true, children: [(0, jsx_runtime_1.jsxs)(renderer_1.View, { style: styles.headerText, children: [(0, jsx_runtime_1.jsx)(renderer_1.Text, { style: styles.title, children: title }), (0, jsx_runtime_1.jsx)(renderer_1.Text, { style: styles.pagination, render: ({ pageNumber, totalPages }) => `${pageNumber}/${totalPages}` })] }), (0, jsx_runtime_1.jsx)(renderer_1.Text, { style: styles.subtitle, children: subtitle }), (0, jsx_runtime_1.jsx)(renderer_1.View, { style: styles.container, children: values.map((value, index) => ((0, jsx_runtime_1.jsxs)(renderer_1.Text, { style: styles.item, children: [(0, jsx_runtime_1.jsxs)(renderer_1.Text, { style: styles.key, children: [value.key, ": "] }), (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: value.value })] }, index))) })] }));
exports.Header = Header;
//# sourceMappingURL=Header.js.map