"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageHeader = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const colors_json_1 = __importDefault(require("@rocket.chat/fuselage-tokens/colors.json"));
const typography_json_1 = require("@rocket.chat/fuselage-tokens/typography.json");
const styles = renderer_1.StyleSheet.create({
    header: {
        flexDirection: 'row',
        alignItems: 'center',
    },
    name: {
        fontSize: typography_json_1.fontScales.p2b.fontSize,
        fontWeight: typography_json_1.fontScales.p2b.fontWeight,
        color: colors_json_1.default.n900,
    },
    time: {
        fontSize: typography_json_1.fontScales.c1.fontSize,
        marginLeft: 4,
    },
});
const MessageHeader = ({ name, time, light }) => ((0, jsx_runtime_1.jsxs)(renderer_1.View, { style: styles.header, wrap: false, children: [(0, jsx_runtime_1.jsx)(renderer_1.Text, { style: styles.name, children: name }), (0, jsx_runtime_1.jsx)(renderer_1.Text, { style: { ...styles.time, color: light ? colors_json_1.default.n600 : colors_json_1.default.n700 }, children: time })] }));
exports.MessageHeader = MessageHeader;
//# sourceMappingURL=MessageHeader.js.map