"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quotes = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const colors_json_1 = __importDefault(require("@rocket.chat/fuselage-tokens/colors.json"));
const typography_json_1 = require("@rocket.chat/fuselage-tokens/typography.json");
const markup_1 = require("../markup");
const MessageHeader_1 = require("./MessageHeader");
const styles = renderer_1.StyleSheet.create({
    wrapper: {
        backgroundColor: colors_json_1.default.n100,
        borderWidth: 1,
        borderColor: colors_json_1.default.n250,
        borderLeftColor: colors_json_1.default.n600,
        borderTopWidth: 1,
        paddingLeft: 16,
        paddingRight: 16,
    },
    quoteMessage: {
        paddingTop: 6,
        paddingBottom: 6,
        fontSize: typography_json_1.fontScales.p2.fontSize,
    },
});
const Quote = ({ quote, children, index }) => ((0, jsx_runtime_1.jsxs)(renderer_1.View, { style: {
        ...styles.wrapper,
        marginTop: !index ? 4 : 16,
    }, children: [(0, jsx_runtime_1.jsx)(MessageHeader_1.MessageHeader, { name: quote.name, time: quote.ts, light: true }), (0, jsx_runtime_1.jsx)(renderer_1.View, { style: styles.quoteMessage, children: (0, jsx_runtime_1.jsx)(markup_1.Markup, { tokens: quote.md }) }), children] }));
const Quotes = ({ quotes }) => quotes.reduceRight((lastQuote, quote, index) => ((0, jsx_runtime_1.jsx)(Quote, { quote: quote, index: index, children: lastQuote })), null);
exports.Quotes = Quotes;
//# sourceMappingURL=Quotes.js.map