"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isSystemMessage = exports.splitByTens = exports.markupEntriesGreaterThan10 = exports.messageLongerThanPage = void 0;
const MAX_MD_ELEMENTS_PER_VIEW = 10;
const MAX_MSG_SIZE = 1200;
const messageLongerThanPage = (message) => (message?.length ?? 0) > MAX_MSG_SIZE;
exports.messageLongerThanPage = messageLongerThanPage;
// When a markup list is greater than 10 (magic number, but a reasonable small/big number) we're gonna split the markdown into multiple <View> element
// So react-pdf can split them evenly across pages
const markupEntriesGreaterThan10 = (messageMd = []) => messageMd.length > MAX_MD_ELEMENTS_PER_VIEW;
exports.markupEntriesGreaterThan10 = markupEntriesGreaterThan10;
const splitByTens = (array = []) => {
    const result = [];
    for (let i = 0; i < array.length; i += 10) {
        result.push(array.slice(i, i + 10));
    }
    return result;
};
exports.splitByTens = splitByTens;
const isSystemMessage = (message) => !!message.t;
exports.isSystemMessage = isSystemMessage;
//# sourceMappingURL=utils.js.map