"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const BoldSpan_1 = __importDefault(require("./BoldSpan"));
const CodeSpan_1 = __importDefault(require("./CodeSpan"));
const EmojiSpan_1 = __importDefault(require("./EmojiSpan"));
const ItalicSpan_1 = __importDefault(require("./ItalicSpan"));
const LinkSpan_1 = __importDefault(require("./LinkSpan"));
const StrikeSpan_1 = __importDefault(require("./StrikeSpan"));
const InlineElements = ({ children }) => ((0, jsx_runtime_1.jsx)(renderer_1.Text, { children: children.map((child, index) => {
        switch (child.type) {
            case 'BOLD':
                return (0, jsx_runtime_1.jsx)(BoldSpan_1.default, { children: child.value }, index);
            case 'STRIKE':
                return (0, jsx_runtime_1.jsx)(StrikeSpan_1.default, { children: child.value }, index);
            case 'ITALIC':
                return (0, jsx_runtime_1.jsx)(ItalicSpan_1.default, { children: child.value }, index);
            case 'LINK':
                return (0, jsx_runtime_1.jsx)(LinkSpan_1.default, { label: Array.isArray(child.value.label) ? child.value.label : [child.value.label] }, index);
            case 'PLAIN_TEXT':
                return (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: child.value }, index);
            case 'EMOJI':
                return (0, jsx_runtime_1.jsx)(EmojiSpan_1.default, { ...child }, index);
            case 'INLINE_CODE':
                return (0, jsx_runtime_1.jsx)(CodeSpan_1.default, { code: child.value.value }, index);
            case 'MENTION_USER':
            case 'MENTION_CHANNEL':
                return (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: child.value?.value }, index);
            default:
                return null;
        }
    }) }));
exports.default = InlineElements;
//# sourceMappingURL=InlineElements.js.map