"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const renderer_1 = require("@react-pdf/renderer");
const react_1 = require("react");
const BoldSpan_1 = __importDefault(require("./BoldSpan"));
const ItalicSpan_1 = __importDefault(require("./ItalicSpan"));
const StrikeSpan_1 = __importDefault(require("./StrikeSpan"));
const LinkSpan = ({ label }) => {
    const children = (0, react_1.useMemo)(() => {
        const labelArray = Array.isArray(label) ? label : [label];
        const labelElements = labelArray.map((child, index) => {
            switch (child.type) {
                case 'PLAIN_TEXT':
                    return (0, jsx_runtime_1.jsx)(renderer_1.Text, { children: child.value.trim() }, index);
                case 'STRIKE':
                    return (0, jsx_runtime_1.jsx)(StrikeSpan_1.default, { children: child.value }, index);
                case 'ITALIC':
                    return (0, jsx_runtime_1.jsx)(ItalicSpan_1.default, { children: child.value }, index);
                case 'BOLD':
                    return (0, jsx_runtime_1.jsx)(BoldSpan_1.default, { children: child.value }, index);
                default:
                    return null;
            }
        });
        return labelElements;
    }, [label]);
    return (0, jsx_runtime_1.jsx)(renderer_1.View, { children: children });
};
exports.default = LinkSpan;
//# sourceMappingURL=LinkSpan.js.map