import Ajv from 'ajv';
const ajv = new Ajv();
const channelsAddAllPropsSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
                activeUsersOnly: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                roomName: {
                    type: 'string',
                },
                activeUsersOnly: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['roomName'],
            additionalProperties: false,
        },
    ],
};
export const isChannelsAddAllProps = ajv.compile(channelsAddAllPropsSchema);
//# sourceMappingURL=ChannelsAddAllProps.js.map