import Ajv from 'ajv';
const ajv = new Ajv();
const channelsOpenPropsSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
                query: {
                    type: 'string',
                    nullable: true,
                },
                sort: {
                    type: 'object',
                    properties: {
                        ts: {
                            type: 'number',
                            enum: [1, -1],
                        },
                    },
                    required: ['ts'],
                    additionalProperties: false,
                    nullable: true,
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                roomName: {
                    type: 'string',
                },
                query: {
                    type: 'string',
                    nullable: true,
                },
                sort: {
                    type: 'object',
                    properties: {
                        ts: {
                            type: 'number',
                            enum: [1, -1],
                        },
                    },
                    required: ['ts'],
                    additionalProperties: false,
                    nullable: true,
                },
            },
            required: ['roomName'],
            additionalProperties: false,
        },
    ],
};
export const isChannelsOpenProps = ajv.compile(channelsOpenPropsSchema);
//# sourceMappingURL=ChannelsOpenProps.js.map