import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const CloudManualRegisterSchema = {
    type: 'object',
    properties: {
        cloudBlob: {
            type: 'string',
        },
    },
    required: ['cloudBlob'],
    additionalProperties: false,
};
export const isCloudManualRegisterProps = ajv.compile(CloudManualRegisterSchema);
const CloudCreateRegistrationIntentSchema = {
    type: 'object',
    properties: {
        resend: {
            type: 'boolean',
        },
        email: {
            type: 'string',
        },
    },
    required: ['resend', 'email'],
    additionalProperties: false,
};
export const isCloudCreateRegistrationIntentProps = ajv.compile(CloudCreateRegistrationIntentSchema);
const CloudConfirmationPollSchema = {
    type: 'object',
    properties: {
        deviceCode: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['deviceCode'],
    additionalProperties: false,
};
export const isCloudConfirmationPollProps = ajv.compile(CloudConfirmationPollSchema);
//# sourceMappingURL=cloud.js.map