import Ajv from 'ajv';
const ajv = new Ajv({ coerceTypes: true });
const dmFilesListPropsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            nullable: true,
        },
        username: {
            type: 'string',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        name: {
            type: 'string',
            nullable: true,
        },
        typeGroup: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    oneOf: [{ required: ['roomId'] }, { required: ['username'] }],
    required: [],
    additionalProperties: false,
};
export const isDmFileProps = ajv.compile(dmFilesListPropsSchema);
//# sourceMappingURL=DmFileProps.js.map