import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const E2eSetUserPublicAndPrivateKeysSchema = {
    type: 'object',
    properties: {
        public_key: {
            type: 'string',
        },
        private_key: {
            type: 'string',
        },
    },
    required: ['public_key', 'private_key'],
    additionalProperties: false,
};
export const isE2eSetUserPublicAndPrivateKeysProps = ajv.compile(E2eSetUserPublicAndPrivateKeysSchema);
const E2eGetUsersOfRoomWithoutKeySchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isE2eGetUsersOfRoomWithoutKeyProps = ajv.compile(E2eGetUsersOfRoomWithoutKeySchema);
const E2eUpdateGroupKeySchema = {
    type: 'object',
    properties: {
        uid: {
            type: 'string',
        },
        rid: {
            type: 'string',
        },
        key: {
            type: 'string',
        },
    },
    required: ['uid', 'rid', 'key'],
    additionalProperties: false,
};
export const isE2eUpdateGroupKeyProps = ajv.compile(E2eUpdateGroupKeySchema);
const E2EProvideUsersGroupKeySchema = {
    type: 'object',
    properties: {
        usersSuggestedGroupKeys: {
            type: 'object',
            additionalProperties: {
                type: 'array',
                items: {
                    type: 'object',
                    properties: {
                        _id: { type: 'string' },
                        key: { type: 'string' },
                        oldKeys: {
                            type: 'array',
                            items: {
                                type: 'object',
                                properties: { e2eKeyId: { type: 'string' }, ts: { type: 'string' }, E2EKey: { type: 'string' } },
                            },
                        },
                    },
                    required: ['_id', 'key'],
                    additionalProperties: false,
                },
            },
        },
    },
    required: ['usersSuggestedGroupKeys'],
    additionalProperties: false,
};
export const isE2EProvideUsersGroupKeyProps = ajv.compile(E2EProvideUsersGroupKeySchema);
const E2EFetchUsersWaitingForGroupKeySchema = {
    type: 'object',
    properties: {
        roomIds: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
    },
    required: ['roomIds'],
    additionalProperties: false,
};
export const isE2EFetchUsersWaitingForGroupKeyProps = ajv.compile(E2EFetchUsersWaitingForGroupKeySchema);
const E2EResetRoomKeySchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        e2eKey: {
            type: 'string',
        },
        e2eKeyId: {
            type: 'string',
        },
    },
    required: ['rid', 'e2eKey', 'e2eKeyId'],
    additionalProperties: false,
};
export const isE2EResetRoomKeyProps = ajv.compile(E2EResetRoomKeySchema);
//# sourceMappingURL=e2e.js.map