import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const emojiCustomDeletePropsSchema = {
    type: 'object',
    properties: {
        emojiId: {
            type: 'string',
        },
    },
    required: ['emojiId'],
    additionalProperties: false,
};
export const isEmojiCustomDelete = ajv.compile(emojiCustomDeletePropsSchema);
const emojiCustomListSchema = {
    type: 'object',
    properties: {
        query: {
            type: 'string',
        },
        updatedSince: {
            type: 'string',
            nullable: true,
        },
        _updatedAt: {
            type: 'string',
        },
        _id: {
            type: 'string',
        },
    },
    required: [],
    additionalProperties: false,
};
export const isEmojiCustomList = ajv.compile(emojiCustomListSchema);
//# sourceMappingURL=emojiCustom.js.map