import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
export const withGroupBaseProperties = (properties = {}, required = []) => ({
    oneOf: [
        {
            type: 'object',
            properties: Object.assign({ roomId: {
                    type: 'string',
                } }, properties),
            required: ['roomId'].concat(required),
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: Object.assign({ roomName: {
                    type: 'string',
                } }, properties),
            required: ['roomName'].concat(required),
            additionalProperties: false,
        },
    ],
});
export const baseSchema = withGroupBaseProperties();
export const withBaseProps = ajv.compile(baseSchema);
export const withUserIdSchema = withGroupBaseProperties({
    userId: {
        type: 'string',
    },
}, ['userId']);
export const withUserIdProps = ajv.compile(withUserIdSchema);
//# sourceMappingURL=BaseProps.js.map