import Ajv from 'ajv';
import { withGroupBaseProperties } from './BaseProps';
const ajv = new Ajv({
    coerceTypes: true,
});
const GroupsMessagesPropsSchema = withGroupBaseProperties({
    roomId: {
        type: 'string',
    },
    roomName: {
        type: 'string',
    },
    mentionIds: {
        type: 'string',
    },
    starredIds: {
        type: 'string',
    },
    pinned: {
        type: 'string',
    },
    count: {
        type: 'number',
        nullable: true,
    },
    offset: {
        type: 'number',
        nullable: true,
    },
    sort: {
        type: 'string',
        nullable: true,
    },
    query: {
        type: 'string',
        nullable: true,
    },
});
export const isGroupsMessagesProps = ajv.compile(GroupsMessagesPropsSchema);
//# sourceMappingURL=GroupsMessagesProps.js.map