import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const PushTokenPropsSchema = {
    type: 'object',
    properties: {
        id: {
            type: 'string',
            nullable: true,
        },
        type: {
            type: 'string',
        },
        value: {
            type: 'string',
        },
        appName: {
            type: 'string',
        },
    },
    required: ['type', 'value', 'appName'],
    additionalProperties: false,
};
export const isPushTokenProps = ajv.compile(PushTokenPropsSchema);
const PushGetPropsSchema = {
    type: 'object',
    properties: {
        id: {
            type: 'string',
        },
    },
    required: ['id'],
    additionalProperties: false,
};
export const isPushGetProps = ajv.compile(PushGetPropsSchema);
//# sourceMappingURL=push.js.map