import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const roleDeletePropsSchema = {
    type: 'object',
    properties: {
        roleId: {
            type: 'string',
        },
    },
    required: ['roleId'],
    additionalProperties: false,
};
export const isRoleDeleteProps = ajv.compile(roleDeletePropsSchema);
const roleAddUserToRolePropsSchema = {
    type: 'object',
    properties: {
        username: {
            type: 'string',
        },
        roleId: {
            type: 'string',
            nullable: true,
        },
        roleName: {
            type: 'string',
            nullable: true,
        },
        roomId: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['username'],
    additionalProperties: false,
};
export const isRoleAddUserToRoleProps = ajv.compile(roleAddUserToRolePropsSchema);
const roleRemoveUserFromRolePropsSchema = {
    type: 'object',
    properties: {
        username: {
            type: 'string',
        },
        roleId: {
            type: 'string',
            nullable: true,
        },
        roleName: {
            type: 'string',
            nullable: true,
        },
        roomId: {
            type: 'string',
            nullable: true,
        },
        scope: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['username'],
    additionalProperties: false,
};
export const isRoleRemoveUserFromRoleProps = ajv.compile(roleRemoveUserFromRolePropsSchema);
const RolesGetUsersInRolePropsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            nullable: true,
        },
        role: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['role'],
    additionalProperties: false,
};
export const isRolesGetUsersInRoleProps = ajv.compile(RolesGetUsersInRolePropsSchema);
//# sourceMappingURL=roles.js.map