import { ajv } from './Ajv';
const RoomsAutoCompleteChannelAndPrivateSchema = {
    type: 'object',
    properties: {
        selector: {
            type: 'string',
        },
    },
    required: ['selector'],
    additionalProperties: false,
};
export const isRoomsAutoCompleteChannelAndPrivateProps = ajv.compile(RoomsAutoCompleteChannelAndPrivateSchema);
const RoomsAutocompleteChannelAndPrivateWithPaginationSchema = {
    type: 'object',
    properties: {
        selector: {
            type: 'string',
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['selector'],
    additionalProperties: false,
};
export const isRoomsAutocompleteChannelAndPrivateWithPaginationProps = ajv.compile(RoomsAutocompleteChannelAndPrivateWithPaginationSchema);
const RoomsAutocompleteAvailableForTeamsSchema = {
    type: 'object',
    properties: {
        name: {
            type: 'string',
        },
    },
    required: ['name'],
    additionalProperties: false,
};
export const isRoomsAutocompleteAvailableForTeamsProps = ajv.compile(RoomsAutocompleteAvailableForTeamsSchema);
const RoomsAutocompleteAdminRoomsPayloadSchema = {
    type: 'object',
    properties: {
        selector: {
            type: 'string',
        },
    },
    required: ['selector'],
    additionalProperties: false,
};
export const isRoomsAutocompleteAdminRoomsPayload = ajv.compile(RoomsAutocompleteAdminRoomsPayloadSchema);
const RoomsInfoSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                roomName: {
                    type: 'string',
                },
            },
            required: ['roomName'],
            additionalProperties: false,
        },
    ],
};
export const isRoomsInfoProps = ajv.compile(RoomsInfoSchema);
const RoomsCreateDiscussionSchema = {
    type: 'object',
    properties: {
        prid: {
            type: 'string',
        },
        pmid: {
            type: 'string',
            nullable: true,
        },
        t_name: {
            type: 'string',
            nullable: true,
        },
        users: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        encrypted: {
            type: 'boolean',
            nullable: true,
        },
        reply: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['prid', 't_name'],
    additionalProperties: false,
};
export const isRoomsCreateDiscussionProps = ajv.compile(RoomsCreateDiscussionSchema);
const RoomsExportSchema = {
    oneOf: [
        {
            type: 'object',
            properties: {
                rid: {
                    type: 'string',
                },
                type: {
                    type: 'string',
                    enum: ['file'],
                },
                format: {
                    type: 'string',
                    enum: ['html', 'json'],
                },
                dateFrom: {
                    type: 'string',
                    nullable: true,
                    format: 'date',
                },
                dateTo: {
                    type: 'string',
                    nullable: true,
                    format: 'date',
                },
            },
            required: ['rid', 'type', 'format'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                rid: {
                    type: 'string',
                },
                type: {
                    type: 'string',
                    enum: ['email'],
                },
                toUsers: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                toEmails: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
                additionalEmails: {
                    type: 'string',
                    nullable: true,
                },
                subject: {
                    type: 'string',
                    nullable: true,
                },
                messages: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    minItems: 1,
                },
            },
            required: ['rid', 'type', 'messages'],
            additionalProperties: false,
        },
    ],
};
export const isRoomsExportProps = ajv.compile(RoomsExportSchema);
const RoomsAdminRoomsSchema = {
    type: 'object',
    properties: {
        filter: {
            type: 'string',
            nullable: true,
        },
        types: {
            type: 'array',
            items: {
                type: 'string',
            },
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
        sort: {
            type: 'string',
            nullable: true,
        },
        query: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isRoomsAdminRoomsProps = ajv.compile(RoomsAdminRoomsSchema);
const RoomsAdminRoomsGetRoomSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isRoomsAdminRoomsGetRoomProps = ajv.compile(RoomsAdminRoomsGetRoomSchema);
const RoomsChangeArchivationStateSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        action: {
            type: 'string',
            nullable: true,
        },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isRoomsChangeArchivationStateProps = ajv.compile(RoomsChangeArchivationStateSchema);
const RoomsSaveRoomSettingsSchema = {
    type: 'object',
    properties: {
        rid: {
            type: 'string',
        },
        roomAvatar: {
            type: 'string',
            nullable: true,
        },
        featured: {
            type: 'boolean',
            nullable: true,
        },
        roomName: {
            type: 'string',
            nullable: true,
        },
        roomTopic: {
            type: 'string',
            nullable: true,
        },
        roomAnnouncement: {
            type: 'string',
            nullable: true,
        },
        roomDescription: {
            type: 'string',
            nullable: true,
        },
        roomType: {
            type: 'string',
            nullable: true,
        },
        readOnly: {
            type: 'boolean',
            nullable: true,
        },
        reactWhenReadOnly: {
            type: 'boolean',
            nullable: true,
        },
        default: {
            type: 'boolean',
            nullable: true,
        },
        encrypted: {
            type: 'boolean',
            nullable: true,
        },
        favorite: {
            type: 'object',
            properties: {
                defaultValue: {
                    type: 'boolean',
                    nullable: true,
                },
                favorite: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            nullable: true,
        },
        retentionEnabled: { type: 'boolean', nullable: true },
        retentionMaxAge: { type: 'number', nullable: true },
        retentionExcludePinned: { type: 'boolean', nullable: true },
        retentionFilesOnly: { type: 'boolean', nullable: true },
        retentionIgnoreThreads: { type: 'boolean', nullable: true },
        retentionOverrideGlobal: { type: 'boolean', nullable: true },
    },
    required: ['rid'],
    additionalProperties: false,
};
export const isRoomsSaveRoomSettingsProps = ajv.compile(RoomsSaveRoomSettingsSchema);
const GETRoomsNameExistsSchema = {
    type: 'object',
    properties: {
        roomName: {
            type: 'string',
        },
    },
    required: ['roomName'],
    additionalProperties: false,
};
export const isGETRoomsNameExists = ajv.compile(GETRoomsNameExistsSchema);
const RoomsIsMemberPropsSchema = {
    type: 'object',
    properties: {
        roomId: { type: 'string', minLength: 1 },
        userId: { type: 'string', minLength: 1 },
        username: { type: 'string', minLength: 1 },
    },
    oneOf: [{ required: ['roomId', 'userId'] }, { required: ['roomId', 'username'] }],
    additionalProperties: false,
};
export const isRoomsIsMemberProps = ajv.compile(RoomsIsMemberPropsSchema);
const RoomsMuteUnmuteUserSchema = {
    type: 'object',
    oneOf: [
        {
            properties: {
                userId: {
                    type: 'string',
                    minLength: 1,
                },
                roomId: {
                    type: 'string',
                    minLength: 1,
                },
            },
            required: ['userId', 'roomId'],
            additionalProperties: false,
        },
        {
            properties: {
                username: {
                    type: 'string',
                    minLength: 1,
                },
                roomId: {
                    type: 'string',
                    minLength: 1,
                },
            },
            required: ['username', 'roomId'],
            additionalProperties: false,
        },
    ],
};
export const isRoomsMuteUnmuteUserProps = ajv.compile(RoomsMuteUnmuteUserSchema);
const roomsImagesPropsSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        startingFromId: {
            type: 'string',
            nullable: true,
        },
        count: {
            type: 'number',
            nullable: true,
        },
        offset: {
            type: 'number',
            nullable: true,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isRoomsImagesProps = ajv.compile(roomsImagesPropsSchema);
const roomsCleanHistorySchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
        latest: {
            type: 'string',
        },
        oldest: {
            type: 'string',
        },
        inclusive: {
            type: 'boolean',
        },
        excludePinned: {
            type: 'boolean',
        },
        filesOnly: {
            type: 'boolean',
        },
        users: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
        limit: {
            type: 'number',
        },
        ignoreDiscussion: {
            type: 'boolean',
        },
        ignoreThreads: {
            type: 'boolean',
        },
    },
    required: ['roomId', 'latest', 'oldest'],
    additionalProperties: false,
};
export const isRoomsCleanHistoryProps = ajv.compile(roomsCleanHistorySchema);
const roomsOpenSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isRoomsOpenProps = ajv.compile(roomsOpenSchema);
const membersOrderedByRoleRolePropsSchema = {
    properties: {
        roomId: {
            type: 'string',
        },
        roomName: {
            type: 'string',
        },
        status: {
            type: 'array',
            items: {
                type: 'string',
            },
        },
        filter: {
            type: 'string',
        },
        count: {
            type: 'integer',
        },
        offset: {
            type: 'integer',
        },
        sort: {
            type: 'string',
        },
    },
    oneOf: [{ required: ['roomId'] }, { required: ['roomName'] }],
    additionalProperties: false,
};
export const isRoomsMembersOrderedByRoleProps = ajv.compile(membersOrderedByRoleRolePropsSchema);
const roomsHideSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
            minLength: 1,
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isRoomsHideProps = ajv.compile(roomsHideSchema);
//# sourceMappingURL=rooms.js.map