import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const SubscriptionsGetSchema = {
    type: 'object',
    properties: {
        updatedSince: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isSubscriptionsGetProps = ajv.compile(SubscriptionsGetSchema);
const SubscriptionsGetOneSchema = {
    type: 'object',
    properties: {
        roomId: {
            type: 'string',
        },
    },
    required: ['roomId'],
    additionalProperties: false,
};
export const isSubscriptionsGetOneProps = ajv.compile(SubscriptionsGetOneSchema);
const SubscriptionsReadSchema = {
    anyOf: [
        {
            type: 'object',
            properties: {
                rid: {
                    type: 'string',
                },
                readThreads: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['rid'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
                readThreads: {
                    type: 'boolean',
                    nullable: true,
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
    ],
};
export const isSubscriptionsReadProps = ajv.compile(SubscriptionsReadSchema);
const SubscriptionsUnreadSchema = {
    anyOf: [
        {
            type: 'object',
            properties: {
                roomId: {
                    type: 'string',
                },
            },
            required: ['roomId'],
            additionalProperties: false,
        },
        {
            type: 'object',
            properties: {
                firstUnreadMessage: {
                    type: 'object',
                    properties: {
                        _id: {
                            type: 'string',
                        },
                    },
                    required: ['_id'],
                    additionalProperties: false,
                },
            },
            required: ['firstUnreadMessage'],
            additionalProperties: false,
        },
    ],
};
export const isSubscriptionsUnreadProps = ajv.compile(SubscriptionsUnreadSchema);
//# sourceMappingURL=subscriptionsEndpoints.js.map