import Ajv from 'ajv';
const ajv = new Ajv({
    coerceTypes: true,
});
const UsersInfoSchema = {
    type: 'object',
    properties: {
        userId: {
            type: 'string',
            nullable: true,
        },
        username: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isUsersInfoProps = ajv.compile(UsersInfoSchema);
const Users2faSendEmailCodeSchema = {
    type: 'object',
    properties: {
        emailOrUsername: {
            type: 'string',
        },
    },
    required: ['emailOrUsername'],
    additionalProperties: false,
};
export const isUsers2faSendEmailCodeProps = ajv.compile(Users2faSendEmailCodeSchema);
const UsersSetAvatarSchema = {
    type: 'object',
    properties: {
        userId: {
            type: 'string',
            nullable: true,
        },
        username: {
            type: 'string',
            nullable: true,
        },
        avatarUrl: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isUsersSetAvatarProps = ajv.compile(UsersSetAvatarSchema);
const UsersResetAvatarSchema = {
    type: 'object',
    properties: {
        userId: {
            type: 'string',
            nullable: true,
        },
        username: {
            type: 'string',
            nullable: true,
        },
    },
    required: [],
    additionalProperties: false,
};
export const isUsersResetAvatarProps = ajv.compile(UsersResetAvatarSchema);
export * from './users/UserCreateParamsPOST';
export * from './users/UserSetActiveStatusParamsPOST';
export * from './users/UserDeactivateIdleParamsPOST';
export * from './users/UsersInfoParamsGet';
export * from './users/UsersListStatusParamsGET';
export * from './users/UsersSendWelcomeEmailParamsPOST';
export * from './users/UserRegisterParamsPOST';
export * from './users/UserLogoutParamsPOST';
export * from './users/UsersListTeamsParamsGET';
export * from './users/UsersAutocompleteParamsGET';
//# sourceMappingURL=users.js.map