"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var capitalize_1 = require("./capitalize");
describe('capitalize', function () {
    it('should convert "xyz" to "Xyz"', function () {
        expect((0, capitalize_1.capitalize)('xyz')).toBe('Xyz');
    });
    it('should convert "xyz xyz" to "Xyz xyz"', function () {
        expect((0, capitalize_1.capitalize)('xyz xyz')).toBe('Xyz xyz');
    });
    it('should convert " xyz" to " xyz"', function () {
        expect((0, capitalize_1.capitalize)(' xyz')).toBe(' xyz');
    });
    it('should convert undefined to ""', function () {
        expect((0, capitalize_1.capitalize)(undefined)).toBe('');
    });
    it('should convert null to ""', function () {
        expect((0, capitalize_1.capitalize)(null)).toBe('');
    });
    it('should convert false to ""', function () {
        expect((0, capitalize_1.capitalize)(false)).toBe('');
    });
    it('should convert true to ""', function () {
        expect((0, capitalize_1.capitalize)(true)).toBe('');
    });
    it('should convert 0 to ""', function () {
        expect((0, capitalize_1.capitalize)(0)).toBe('');
    });
    it('should convert 1 to ""', function () {
        expect((0, capitalize_1.capitalize)(1)).toBe('');
    });
});
//# sourceMappingURL=capitalize.spec.js.map