"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var unescapeHTML_1 = require("./unescapeHTML");
describe('unescapeHTML', function () {
    it('works', function () {
        expect((0, unescapeHTML_1.unescapeHTML)('&lt;div&gt;Blah &amp; &quot;blah&quot; &amp; &apos;blah&#39;&lt;/div&gt;')).toBe('<div>Blah & "blah" & \'blah\'</div>');
        expect((0, unescapeHTML_1.unescapeHTML)('&amp;lt;')).toBe('&lt;');
        expect((0, unescapeHTML_1.unescapeHTML)('&apos;')).toBe("'");
        expect((0, unescapeHTML_1.unescapeHTML)('&#39;')).toBe("'");
        expect((0, unescapeHTML_1.unescapeHTML)('&#0039;')).toBe("'");
        expect((0, unescapeHTML_1.unescapeHTML)('&#x4a;')).toBe('J');
        expect((0, unescapeHTML_1.unescapeHTML)('&#x04A;')).toBe('J');
        expect((0, unescapeHTML_1.unescapeHTML)('&#X4A;')).toBe('&#X4A;');
        expect((0, unescapeHTML_1.unescapeHTML)('&_#39;')).toBe('&_#39;');
        expect((0, unescapeHTML_1.unescapeHTML)('&#39_;')).toBe('&#39_;');
        expect((0, unescapeHTML_1.unescapeHTML)('&amp;#38;')).toBe('&#38;');
        expect((0, unescapeHTML_1.unescapeHTML)('&#38;amp;')).toBe('&amp;');
        expect((0, unescapeHTML_1.unescapeHTML)('&#39;')).toBe("'");
        expect((0, unescapeHTML_1.unescapeHTML)('')).toBe('');
        expect((0, unescapeHTML_1.unescapeHTML)('&nbsp;')).toBe(' ');
        expect((0, unescapeHTML_1.unescapeHTML)('what is the &yen; to &pound; to &euro; conversion process?')).toBe('what is the ¥ to £ to € conversion process?');
        expect((0, unescapeHTML_1.unescapeHTML)('&reg; trademark')).toBe('® trademark');
        expect((0, unescapeHTML_1.unescapeHTML)('&trade; unregistered trademark')).toBe('™ unregistered trademark');
        expect((0, unescapeHTML_1.unescapeHTML)('&copy; 1992. License available for 50 &cent;')).toBe('© 1992. License available for 50 ¢');
        expect((0, unescapeHTML_1.unescapeHTML)('&nbsp;')).toBe(' ');
        expect((0, unescapeHTML_1.unescapeHTML)('&nbsp;')).toBe(' ');
        expect((0, unescapeHTML_1.unescapeHTML)(null)).toBe('');
        expect((0, unescapeHTML_1.unescapeHTML)(undefined)).toBe('');
        expect((0, unescapeHTML_1.unescapeHTML)(5)).toBe('5');
    });
});
//# sourceMappingURL=unescapeHTML.spec.js.map