import { escapeHTML } from './escapeHTML';
describe('escapeHTML', function () {
    it('works', function () {
        expect(escapeHTML('<div>Blah & "blah" & \'blah\'</div>')).toBe('&lt;div&gt;Blah &amp; &quot;blah&quot; &amp; &#39;blah&#39;&lt;/div&gt;');
        expect(escapeHTML('&lt;')).toBe('&amp;lt;');
        expect(escapeHTML(' ')).toBe(' ');
        expect(escapeHTML('¢')).toBe('&cent;');
        expect(escapeHTML('¢ £ ¥ € © ® ™')).toBe('&cent; &pound; &yen; &euro; &copy; &reg; &trade;');
        expect(escapeHTML(5)).toBe('5');
        expect(escapeHTML('')).toBe('');
        expect(escapeHTML(null)).toBe('');
        expect(escapeHTML(undefined)).toBe('');
    });
});
//# sourceMappingURL=escapeHTML.spec.js.map