import { escapeRegExp } from './escapeRegExp';
describe('escapeRegExp', function () {
    it('should keep strings with letters only unchanged', function () {
        expect(escapeRegExp('word')).toBe('word');
    });
    it('should escape slashes', function () {
        expect(escapeRegExp('/slashes/')).toBe('\\/slashes\\/');
        expect(escapeRegExp('\\backslashes\\')).toBe('\\\\backslashes\\\\');
        expect(escapeRegExp('\\border of word')).toBe('\\\\border of word');
    });
    it('should escape special group', function () {
        var _a, _b, _c, _d, _e, _f, _g;
        expect(escapeRegExp('(?:non-capturing)')).toBe('\\(\\?\\:non\\-capturing\\)');
        expect((_a = new RegExp("".concat(escapeRegExp('(?:'), "([^)]+)")).exec('(?:non-capturing)')) === null || _a === void 0 ? void 0 : _a[1]).toBe('non-capturing');
        expect(escapeRegExp('(?=positive-lookahead)')).toBe('\\(\\?\\=positive\\-lookahead\\)');
        expect((_b = new RegExp("".concat(escapeRegExp('(?='), "([^)]+)")).exec('(?=positive-lookahead)')) === null || _b === void 0 ? void 0 : _b[1]).toBe('positive-lookahead');
        expect(escapeRegExp('(?<=positive-lookbehind)')).toBe('\\(\\?<\\=positive\\-lookbehind\\)');
        expect((_c = new RegExp("".concat(escapeRegExp('(?<='), "([^)]+)")).exec('(?<=positive-lookbehind)')) === null || _c === void 0 ? void 0 : _c[1]).toBe('positive-lookbehind');
        expect(escapeRegExp('(?!negative-lookahead)')).toBe('\\(\\?\\!negative\\-lookahead\\)');
        expect((_d = new RegExp("".concat(escapeRegExp('(?!'), "([^)]+)")).exec('(?!negative-lookahead)')) === null || _d === void 0 ? void 0 : _d[1]).toBe('negative-lookahead');
        expect(escapeRegExp('(?<!negative-lookbehind)')).toBe('\\(\\?<\\!negative\\-lookbehind\\)');
        expect((_e = new RegExp("".concat(escapeRegExp('(?<!'), "([^)]+)")).exec('(?<!negative-lookbehind)')) === null || _e === void 0 ? void 0 : _e[1]).toBe('negative-lookbehind');
        expect(escapeRegExp('[\\w]+')).toBe('\\[\\\\w\\]\\+');
        expect((_f = new RegExp("".concat(escapeRegExp('['), "([^\\]]+)")).exec('[character class]')) === null || _f === void 0 ? void 0 : _f[1]).toBe('character class');
        expect((_g = new RegExp(escapeRegExp('<div>')).exec('<td><div></td>')) === null || _g === void 0 ? void 0 : _g[0]).toBe('<div>');
        expect(escapeRegExp('{5,2}')).toBe('\\{5,2\\}');
        expect(escapeRegExp('/([.*+?^=!:${}()|[\\]\\/\\\\])/g')).toBe('\\/\\(\\[\\.\\*\\+\\?\\^\\=\\!\\:\\$\\{\\}\\(\\)\\|\\[\\\\\\]\\\\\\/\\\\\\\\\\]\\)\\/g');
    });
    it('should not escape whitespace', function () {
        expect(escapeRegExp('\\n\\r\\t')).toBe('\\\\n\\\\r\\\\t');
        expect(escapeRegExp('\n\r\t')).toBe('\n\r\t');
    });
    it('ignores errors from non-string argument', function () {
        expect(function () { return escapeRegExp(false); }).not.toThrow();
        expect(function () { return escapeRegExp(); }).not.toThrow();
        expect(function () { return escapeRegExp(null); }).not.toThrow();
        expect(function () { return escapeRegExp(42); }).not.toThrow();
    });
});
//# sourceMappingURL=escapeRegExp.spec.js.map