import { cssSupports } from '@rocket.chat/css-supports';
import { node, RULESET, serialize } from 'stylis';
import { attachDeclaration, isDeclaration, isRuleSet } from './elements';
import { compileOperations } from './operations';
export var createLogicalPropertiesMiddleware = function (_a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.isPropertySupported, isPropertySupported = _c === void 0 ? function (property) {
        return cssSupports("".concat(property, ":inherit"));
    } : _c, _d = _b.isPropertyValueSupported, isPropertyValueSupported = _d === void 0 ? function (property, value) {
        return cssSupports("".concat(property, ":").concat(value));
    } : _d;
    var ops = compileOperations({
        isPropertySupported: isPropertySupported,
        isPropertyValueSupported: isPropertyValueSupported,
    });
    return function (ruleSet, _, __, callback) {
        if (!isRuleSet(ruleSet) || ruleSet.root !== null) {
            return undefined;
        }
        var ltrRuleSet = node(ruleSet.props
            .map(function (selector) { return "html:not([dir=rtl]) ".concat(selector); })
            .join(','), undefined, undefined, RULESET, ruleSet.props.map(function (selector) { return "html:not([dir=rtl]) ".concat(selector); }), [], 0);
        var rtlRuleSet = node(ruleSet.props.map(function (selector) { return "[dir=rtl] ".concat(selector); }).join(','), undefined, undefined, RULESET, ruleSet.props.map(function (selector) { return "[dir=rtl] ".concat(selector); }), [], 0);
        var rules = ruleSet.children;
        ruleSet.children = [];
        ruleSet.return = '';
        for (var _i = 0, _a = rules; _i < _a.length; _i++) {
            var rule = _a[_i];
            if (!isDeclaration(rule)) {
                ruleSet.children.push(rule);
                continue;
            }
            var op = ops.get(rule.props);
            if (op) {
                op(rule.children, ruleSet, ltrRuleSet, rtlRuleSet);
                continue;
            }
            attachDeclaration(rule.props, rule.children, ruleSet);
        }
        return serialize([ltrRuleSet, rtlRuleSet], callback);
    };
};
//# sourceMappingURL=middleware.js.map