"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertPathsIntoSubObjects = convertPathsIntoSubObjects;
function convertPathsIntoSubObjects(object) {
    const newObject = {};
    for (const key of Object.keys(object)) {
        const value = object[key];
        if (!value && typeof value !== 'boolean') {
            continue;
        }
        const keyProperties = key.split('.');
        if (!keyProperties.length) {
            continue;
        }
        let current = newObject;
        const finalProperty = keyProperties.pop();
        for (const property of keyProperties) {
            if (!(property in current) || typeof current[property] !== 'object') {
                current[property] = {};
            }
            current = current[property];
        }
        if (current[finalProperty]) {
            current[finalProperty] = {
                ...(typeof value === 'object' && value),
                ...current[finalProperty],
            };
        }
        else {
            current[finalProperty] = value;
        }
    }
    return newObject;
}
//# sourceMappingURL=convertPathsIntoSubObjects.js.map