"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.objectMap = objectMap;
function objectMap(object, cb, recursive = false) {
    return Object.fromEntries(Object.keys(object)
        .map((key) => {
        const value = object[key];
        if (recursive && value && typeof value === 'object' && !Array.isArray(value) && !(value instanceof Date)) {
            const newValue = objectMap(value, cb, true);
            return cb({ key, value: newValue });
        }
        return cb({ key, value });
    })
        .filter((item) => !!item)
        .map((item) => [item.key, item.value]));
}
//# sourceMappingURL=objectMap.js.map