import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { useLayoutEffect } from 'react';
import { createPortal } from 'react-dom';
import { ensureAnchorElement, refAnchorElement, unrefAnchorElement } from '../helpers/anchors';
const AnchorPortal = ({ id, children }) => {
    const anchorElement = ensureAnchorElement(id);
    useLayoutEffect(() => {
        refAnchorElement(anchorElement);
        return () => {
            unrefAnchorElement(anchorElement);
        };
    }, [anchorElement]);
    return _jsx(_Fragment, { children: createPortal(children, anchorElement) });
};
export default AnchorPortal;
//# sourceMappingURL=AnchorPortal.js.map