var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Palette } from '@rocket.chat/fuselage';
const AnnouncementBanner = (_a) => {
    var { children, className, onClick } = _a, props = __rest(_a, ["children", "className", "onClick"]);
    const announcementBar = css `
		background-color: ${Palette.status['status-background-info'].theme('announcement-background')};
		color: ${Palette.text['font-pure-black'].theme('announcement-text')};
		cursor: pointer;
		transition: transform 0.2s ease-out;
		a:link {
			color: ${Palette.text['font-pure-black'].theme('announcement-text')};
			text-decoration: underline;
		}
		> * {
			flex: auto;
		}
		&:hover {
			text-decoration: underline;
		}
	`;
    return (_jsx(Box, Object.assign({ focusable: true, height: 'x40', pi: 24, alignItems: 'center', display: 'flex', fontScale: 'p2m', textAlign: 'center', borderRadius: 0, className: [announcementBar, className], tabIndex: onClick ? 0 : -1, role: onClick ? 'button' : 'banner', onClick: onClick }, props, { children: _jsx(Box, { withTruncatedText: true, w: 'none', children: children }) })));
};
export default AnnouncementBanner;
//# sourceMappingURL=AnnouncementBanner.js.map