var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Button, Modal, ModalClose, ModalContent, ModalFooter, ModalFooterAnnotation, ModalFooterControllers, ModalHeader, ModalHeaderText, ModalIcon, ModalTagline, ModalTitle, } from '@rocket.chat/fuselage';
import { useEffectEvent } from '@rocket.chat/fuselage-hooks';
import { useId, useEffect, useRef } from 'react';
import { useTranslation } from 'react-i18next';
import { withDoNotAskAgain } from './withDoNotAskAgain';
import { modalStore } from '../../../providers/ModalProvider/ModalStore';
const iconMap = {
    danger: 'modal-warning',
    warning: 'modal-warning',
    info: 'info',
    success: 'check',
};
const getButtonProps = (variant) => {
    switch (variant) {
        case 'danger':
            return { danger: true };
        case 'secondary-danger':
            return { secondary: true, danger: true };
        case 'warning':
        case 'upsell':
            return { primary: true };
        default:
            return {};
    }
};
const renderIcon = (icon, variant) => {
    if (icon === null || iconMap[variant] === undefined) {
        return null;
    }
    if (icon === undefined) {
        return _jsx(ModalIcon, { color: variant, name: iconMap[variant] });
    }
    if (typeof icon === 'string') {
        return _jsx(ModalIcon, { name: icon });
    }
    return icon;
};
const GenericModal = (_a) => {
    var { variant = 'info', children, cancelText, confirmText, title, icon, onCancel, onClose = onCancel, onDismiss = onClose, onConfirm, dontAskAgain, confirmDisabled, tagline, wrapperFunction, annotation } = _a, props = __rest(_a, ["variant", "children", "cancelText", "confirmText", "title", "icon", "onCancel", "onClose", "onDismiss", "onConfirm", "dontAskAgain", "confirmDisabled", "tagline", "wrapperFunction", "annotation"]);
    const { t } = useTranslation();
    const genericModalId = useId();
    const dismissedRef = useRef(true);
    const taglineColor = variant === 'upsell' ? 'annotation' : undefined;
    const handleConfirm = useEffectEvent(() => {
        dismissedRef.current = false;
        onConfirm === null || onConfirm === void 0 ? void 0 : onConfirm();
    });
    const handleCancel = useEffectEvent(() => {
        dismissedRef.current = false;
        onCancel === null || onCancel === void 0 ? void 0 : onCancel();
    });
    const handleCloseButtonClick = useEffectEvent(() => {
        dismissedRef.current = true;
        onClose === null || onClose === void 0 ? void 0 : onClose();
    });
    const handleDismiss = useEffectEvent(() => {
        dismissedRef.current = true;
        onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss();
    });
    useEffect(() => {
        const thisModal = modalStore.current;
        return () => {
            if (thisModal === modalStore.current)
                return;
            if (!dismissedRef.current)
                return;
            handleDismiss();
        };
    }, [handleDismiss]);
    return (_jsxs(Modal, Object.assign({ "aria-labelledby": `${genericModalId}-title`, wrapperFunction: wrapperFunction }, props, { children: [_jsxs(ModalHeader, { children: [renderIcon(icon, variant), _jsxs(ModalHeaderText, { children: [tagline && _jsx(ModalTagline, { color: taglineColor, children: tagline }), _jsx(ModalTitle, { id: `${genericModalId}-title`, children: title !== null && title !== void 0 ? title : t('Are_you_sure') })] }), onClose && _jsx(ModalClose, { "aria-label": t('Close'), onClick: handleCloseButtonClick })] }), _jsx(ModalContent, { fontScale: 'p2', children: children }), _jsxs(ModalFooter, { justifyContent: dontAskAgain || annotation ? 'space-between' : 'end', children: [dontAskAgain, annotation && !dontAskAgain && _jsx(ModalFooterAnnotation, { children: annotation }), _jsxs(ModalFooterControllers, { children: [onCancel && (_jsx(Button, { secondary: true, onClick: handleCancel, children: cancelText !== null && cancelText !== void 0 ? cancelText : t('Cancel') })), wrapperFunction && (_jsx(Button, Object.assign({}, getButtonProps(variant), { type: 'submit', disabled: confirmDisabled, children: confirmText !== null && confirmText !== void 0 ? confirmText : t('Ok') }))), !wrapperFunction && onConfirm && (_jsx(Button, Object.assign({}, getButtonProps(variant), { onClick: handleConfirm, disabled: confirmDisabled, children: confirmText !== null && confirmText !== void 0 ? confirmText : t('Ok') })))] })] })] })));
};
export const GenericModalDoNotAskAgain = withDoNotAskAgain(GenericModal);
export default GenericModal;
//# sourceMappingURL=GenericModal.js.map