var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Icon } from '@rocket.chat/fuselage';
import { forwardRef } from 'react';
import { useTranslation } from 'react-i18next';
const MultiSelectCustomAnchor = forwardRef(function MultiSelectCustomAnchor(_a, ref) {
    var { className, collapsed, selectedOptionsCount, selectedOptionsTitle, defaultTitle, maxCount } = _a, props = __rest(_a, ["className", "collapsed", "selectedOptionsCount", "selectedOptionsTitle", "defaultTitle", "maxCount"]);
    const { t } = useTranslation();
    const customStyle = css `
		&:hover {
			cursor: pointer;
		}
	`;
    const isDirty = selectedOptionsCount > 0 && selectedOptionsCount !== maxCount - 1;
    return (_jsxs(Box, Object.assign({ ref: ref, role: 'button', tabIndex: 0, display: 'flex', justifyContent: 'space-between', alignItems: 'center', h: 'x40', className: ['rcx-input-box__wrapper', customStyle, ...(Array.isArray(className) ? className : [className])].filter(Boolean) }, props, { children: [isDirty ? `${t(selectedOptionsTitle)} (${selectedOptionsCount})` : t(defaultTitle), _jsx(Icon, { name: collapsed ? 'chevron-up' : 'chevron-down', fontSize: 'x20', color: 'hint' })] })));
});
export default MultiSelectCustomAnchor;
//# sourceMappingURL=MultiSelectCustomAnchor.js.map