import { useTranslation } from 'react-i18next';
export const useFilteredOptions = (optionSearch, options) => {
    const { t } = useTranslation();
    if (!optionSearch)
        return options;
    let filtered = [];
    options.forEach((option) => {
        if (t(option.text)
            .toLowerCase()
            .includes(optionSearch.toLowerCase())) {
            filtered = [...filtered, option];
        }
    });
    return filtered;
};
//# sourceMappingURL=useFilteredOptions.js.map