var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Icon } from '@rocket.chat/fuselage';
import { useId } from 'react';
import { useTranslation } from 'react-i18next';
const getIconProps = (isValid, t) => isValid
    ? {
        'name': 'success-circle',
        'aria-label': t('Success'),
        'color': 'status-font-on-success',
    }
    : {
        'name': 'error-circle',
        'aria-label': t('Error'),
        'color': 'status-font-on-danger',
    };
export const PasswordVerifierItem = (_a) => {
    var { isValid } = _a, props = __rest(_a, ["isValid"]);
    const { t } = useTranslation();
    const icon = getIconProps(isValid, t);
    const id = useId();
    const iconId = `${id}-icon`;
    const textId = `${id}-text`;
    const requirementText = t(`${props.name}-label`, 'limit' in props ? { limit: props.limit } : undefined);
    return (_jsxs(Box, { display: 'flex', flexBasis: props.vertical ? '100%' : '50%', alignItems: 'center', mbe: 8, fontScale: 'c1', color: icon.color, role: 'listitem', "aria-hidden": 'false', "aria-labelledby": `${iconId} ${textId}`, children: [_jsx(Icon, Object.assign({ id: iconId, "aria-hidden": 'false', size: 'x16', mie: 4 }, icon)), _jsx("span", { id: textId, children: requirementText })] }));
};
//# sourceMappingURL=PasswordVerifierItem.js.map