import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { useId } from 'react';
import { useTranslation } from 'react-i18next';
import { PasswordVerifierItem } from './PasswordVerifierItem';
export const PasswordVerifierList = ({ id, validations, vertical = true }) => {
    const { t } = useTranslation();
    const uniqueId = useId();
    if (!(validations === null || validations === void 0 ? void 0 : validations.length)) {
        return _jsx("span", { id: id, hidden: true });
    }
    return (_jsxs(_Fragment, { children: [_jsx("span", { id: id, hidden: true, children: t('Password_Policy_Aria_Description') }), _jsxs(Box, { display: 'flex', flexDirection: 'column', mbs: 8, children: [_jsx(Box, { mbe: 8, fontScale: 'c2', id: uniqueId, "aria-hidden": true, children: t('Password_must_have') }), _jsx(Box, { display: 'flex', flexWrap: 'wrap', role: 'list', "aria-labelledby": uniqueId, "aria-live": 'polite', children: validations.map((validation) => (_jsx(PasswordVerifierItem, Object.assign({ vertical: vertical }, validation), validation.name))) })] })] }));
};
//# sourceMappingURL=PasswordVerifierList.js.map