var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { StatusBullet } from '@rocket.chat/fuselage';
import { memo } from 'react';
import { useTranslation } from 'react-i18next';
function UserStatus(_a) {
    var { small, status } = _a, props = __rest(_a, ["small", "status"]);
    const { t } = useTranslation();
    const size = small ? 'small' : 'large';
    switch (status) {
        case 'online':
            return _jsx(StatusBullet, Object.assign({ size: size, status: status }, props));
        case 'busy':
            return _jsx(StatusBullet, Object.assign({ size: size, status: status }, props));
        case 'away':
            return _jsx(StatusBullet, Object.assign({ size: size, status: status }, props));
        case 'offline':
            return _jsx(StatusBullet, Object.assign({ size: size, status: status }, props));
        case 'disabled':
            return _jsx(StatusBullet, Object.assign({ size: size, status: status }, props));
        default:
            return _jsx(StatusBullet, Object.assign({ size: size, title: t('Loading') }, props));
    }
}
export default memo(UserStatus);
//# sourceMappingURL=UserStatus.js.map