var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx } from "react/jsx-runtime";
import { Button } from '@rocket.chat/fuselage';
import { useTranslation } from 'react-i18next';
import { useWizardContext } from './useWizardContext';
/**
 * A specialized button for navigating to the next step within a Wizard component.
 *
 * This button is context-aware and will automatically trigger the `next` function
 * from the `WizardContext` when clicked.
 *
 * The automatic step navigation can be prevented in two ways:
 * 1. By setting the `manual` prop to `true`.
 * 2. By calling `event.preventDefault()` inside the `onClick` event handler.
 *
 * This is particularly useful when the button needs to perform another primary action,
 * such as submitting a form, before manually proceeding to the next step.
 *
 * Inherits all props from Button, except for `primary` and `onClick`, which are managed internally.
 * @param {object} props - The component's props.
 * @param {ReactNode} [props.children='Next'] - Button label.
 * @param {boolean} [props.disabled=false] - Disables the button, unless the current step does not have a next step, which always takes priority.
 * @param {boolean} [props.manual=false] - Prevents automatic navigation to the next step.
 * @param {(event?: MouseEvent<HTMLButtonElement>) => unknown | Promise<unknown>} [props.onClick] - Click handler.
 * @returns {JSX.Element} The rendered button.
 *
 * @example
 * <WizardNextButton onClick={handleAction} />
 */
const WizardNextButton = (_a) => {
    var { children, disabled = false, manual, onClick } = _a, props = __rest(_a, ["children", "disabled", "manual", "onClick"]);
    const { t } = useTranslation();
    const { next, currentStep } = useWizardContext();
    const handleClick = (event) => __awaiter(void 0, void 0, void 0, function* () {
        yield (onClick === null || onClick === void 0 ? void 0 : onClick(event));
        if (manual || event.isDefaultPrevented()) {
            return;
        }
        next();
    });
    return (_jsx(Button, Object.assign({ primary: true }, props, { disabled: !(currentStep === null || currentStep === void 0 ? void 0 : currentStep.next) || disabled, onClick: handleClick, children: children || t('Next') })));
};
export default WizardNextButton;
//# sourceMappingURL=WizardNextButton.js.map