/**
 * Represents a node in the linked list for managing wizard steps.
 * It contains the step metadata and pointers to the next and previous nodes.
 */
class StepNode {
    /**
     * Creates an instance of StepNode.
     * @param value - The metadata for the step.
     * @param disabled - Whether the step should be initially disabled. Defaults to true.
     */
    constructor(value, disabled = true) {
        this.next = null;
        this.prev = null;
        this.disabled = true;
        this.value = value;
        this.disabled = disabled;
    }
    get id() {
        return this.value.id;
    }
    get title() {
        return this.value.title;
    }
    setDisabled(disabled) {
        this.disabled = disabled;
    }
    enable() {
        this.setDisabled(false);
    }
    disable() {
        this.setDisabled(true);
    }
}
export default StepNode;
//# sourceMappingURL=StepNode.js.map