import { useEffect, useState } from 'react';
export const useAutoSequence = (sequence, delay = 700) => {
    const [index, setIndex] = useState(0);
    useEffect(() => {
        const timer = setInterval(() => setIndex((index) => index + 1), delay);
        return () => {
            clearInterval(timer);
        };
    }, [delay]);
    return sequence[index % sequence.length];
};
//# sourceMappingURL=useAutoSequence.js.map