import { Emitter } from '@rocket.chat/emitter';
import { useCallback, useEffect, useSyncExternalStore } from 'react';
const ee = new Emitter();
const titles = new Set();
const useReactiveDocumentTitle = () => useSyncExternalStore(useCallback((callback) => ee.on('change', callback), []), () => Array.from(titles)
    .reverse()
    .map(({ title }) => title)
    .join(' - '));
const useReactiveDocumentTitleKey = () => useSyncExternalStore(useCallback((callback) => ee.on('change', callback), []), () => Array.from(titles)
    .filter(({ refocus }) => refocus)
    .map(({ title }) => title)
    .join(' - '));
export const useDocumentTitle = (documentTitle, refocus = true) => {
    useEffect(() => {
        const titleObj = {
            title: documentTitle,
            refocus,
        };
        if (titleObj.title) {
            titles.add(titleObj);
        }
        ee.emit('change');
        return () => {
            titles.delete(titleObj);
            ee.emit('change');
        };
    }, [documentTitle, refocus]);
    return { title: useReactiveDocumentTitle(), key: useReactiveDocumentTitleKey() };
};
//# sourceMappingURL=useDocumentTitle.js.map