import { jsx as _jsx } from "react/jsx-runtime";
import { useEffectEvent } from '@rocket.chat/fuselage-hooks';
import { ModalContext } from '@rocket.chat/ui-contexts';
import { useMemo, memo, useSyncExternalStore } from 'react';
import { modalStore } from './ModalStore';
const ModalProvider = ({ children, region }) => {
    const currentModal = useSyncExternalStore(modalStore.subscribe, modalStore.getSnapshot);
    const setModal = useEffectEvent((modal) => {
        if (typeof modal === 'function') {
            modalStore.open(modal(), region);
            return;
        }
        modalStore.open(modal, region);
    });
    const contextValue = useMemo(() => ({
        modal: {
            setModal,
        },
        currentModal: {
            component: currentModal === null || currentModal === void 0 ? void 0 : currentModal.node,
            region: currentModal === null || currentModal === void 0 ? void 0 : currentModal.region,
        },
        region,
    }), [currentModal === null || currentModal === void 0 ? void 0 : currentModal.node, currentModal === null || currentModal === void 0 ? void 0 : currentModal.region, region, setModal]);
    return _jsx(ModalContext.Provider, { value: contextValue, children: children });
};
export default memo(ModalProvider);
//# sourceMappingURL=ModalProvider.js.map