"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePasswordPolicy = void 0;
const password_policies_1 = require("@rocket.chat/password-policies");
const react_1 = require("react");
const usePasswordPolicy = (options) => {
    const policy = (0, react_1.useMemo)(() => new password_policies_1.PasswordPolicy(options), [options]);
    return (0, react_1.useCallback)((password) => {
        const validations = policy.sendValidationMessage(password);
        return {
            validations,
            valid: validations.every(({ isValid }) => isValid),
        };
    }, [policy]);
};
exports.usePasswordPolicy = usePasswordPolicy;
//# sourceMappingURL=usePasswordPolicy.js.map