"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRolesDescription = void 0;
const react_1 = require("react");
const AuthorizationContext_1 = require("../AuthorizationContext");
const useRolesDescription = () => {
    const { getRoles, subscribeToRoles } = (0, react_1.useContext)(AuthorizationContext_1.AuthorizationContext);
    const roles = (0, react_1.useSyncExternalStore)(subscribeToRoles, getRoles);
    return (0, react_1.useCallback)((ids) => ids.map((role) => { var _a, _b; return ((_a = roles.get(role)) === null || _a === void 0 ? void 0 : _a.description) || ((_b = roles.get(role)) === null || _b === void 0 ? void 0 : _b.name) || role; }), [roles]);
};
exports.useRolesDescription = useRolesDescription;
//# sourceMappingURL=useRolesDescription.js.map