"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useWriteStream = useWriteStream;
const react_1 = require("react");
const ServerContext_1 = require("../ServerContext");
function useWriteStream(streamName) {
    const { writeStream } = (0, react_1.useContext)(ServerContext_1.ServerContext);
    if (!writeStream) {
        throw new Error(`cannot use useWriteStream(${streamName}) hook without a wrapping ServerContext`);
    }
    return (0, react_1.useCallback)((eventName, ...args) => writeStream(streamName, eventName, ...args), [writeStream, streamName]);
}
//# sourceMappingURL=useWriteStream.js.map