import { jsx as _jsx } from "react/jsx-runtime";
import { Box, Icon } from '@rocket.chat/fuselage';
const styles = {
    ended: {
        icon: 'phone-off',
        color: 'hint',
        backgroundColor: 'surface-neutral',
    },
    incoming: {
        icon: 'phone-in',
        color: 'status-font-on-info',
        backgroundColor: 'status-background-info',
    },
    outgoing: {
        icon: 'phone',
        color: 'status-font-on-success',
        backgroundColor: 'status-background-success',
    },
};
const VideoConfMessageIcon = ({ variant = 'ended' }) => (_jsx(Box, { size: 'x28', alignItems: 'center', justifyContent: 'center', display: 'flex', borderRadius: 'x4', backgroundColor: styles[variant].backgroundColor, children: _jsx(Icon, { size: 'x20', name: styles[variant].icon, color: styles[variant].color }) }));
export default VideoConfMessageIcon;
//# sourceMappingURL=VideoConfMessageIcon.js.map