import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { getUserDisplayName } from '@rocket.chat/core-typings';
import { Avatar, Box, Icon } from '@rocket.chat/fuselage';
import { useSetting, useUserAvatarPath, useUserPreference } from '@rocket.chat/ui-contexts';
import { memo } from 'react';
const MAX_USERS = 3;
const VideoConfMessageUserStack = ({ users }) => {
    const displayAvatars = useUserPreference('displayAvatars');
    const showRealName = useSetting('UI_Use_Real_Name', false);
    const getUserAvatarPath = useUserAvatarPath();
    return (_jsxs(Box, { mi: 4, children: [displayAvatars && (_jsx(Box, { display: 'flex', alignItems: 'center', mi: 'neg-x2', children: users.slice(0, MAX_USERS).map(({ name, username }, index) => (_jsx(Box, { mi: 2, children: _jsx(Avatar, { size: 'x28', alt: username || '', title: getUserDisplayName(name, username, showRealName), url: getUserAvatarPath(username) }) }, index))) })), !displayAvatars && _jsx(Icon, { size: 'x20', name: 'user' })] }));
};
export default memo(VideoConfMessageUserStack);
//# sourceMappingURL=VideoConfMessageUserStack.js.map