import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { css } from '@rocket.chat/css-in-js';
import { Box, Button, Modal, ModalHeader, ModalTitle, ModalClose, ModalContent, ModalFooter, ModalFooterControllers, } from '@rocket.chat/fuselage';
import { useAbsoluteUrl, useSetModal } from '@rocket.chat/ui-contexts';
import { useId } from 'react';
import { useTranslation } from 'react-i18next';
// MarkdownText is a bit overkill for this
// This css rules ensures that `\n` actually breaks lines.
const breakSpaces = css `
	white-space: break-spaces;
`;
const getFooter = (type, { onCancel, onConfirm, onClose, t, }) => {
    switch (type) {
        case 'denied':
            return [
                _jsx(Button, { onClick: onClose, children: t('Cancel') }, 'cancel'),
            ];
        case 'incomingPrompt':
            return [
                _jsx(Button, { danger: true, onClick: onCancel, icon: 'phone-off', children: t('VoIP_cancel_and_reject') }, 'cancel'),
                _jsx(Button, { success: true, onClick: onConfirm, icon: 'phone', children: t('VoIP_allow_and_accept') }, 'confirm'),
            ];
        case 'outgoingPrompt':
            return [
                _jsx(Button, { onClick: onClose, children: t('Cancel') }, 'cancel'),
                _jsx(Button, { success: true, onClick: onConfirm, icon: 'phone', children: t('VoIP_allow_and_call') }, 'confirm'),
            ];
        case 'deviceChangePrompt':
            return [
                _jsx(Button, { onClick: onClose, children: t('Cancel') }, 'cancel'),
                _jsx(Button, { primary: true, onClick: onConfirm, children: t('Allow') }, 'confirm'),
            ];
    }
};
const PermissionFlowModal = ({ onCancel, onConfirm, type }) => {
    const { t } = useTranslation();
    const modalId = useId();
    const absoluteUrl = useAbsoluteUrl();
    const setModal = useSetModal();
    const onClose = () => {
        setModal(null);
    };
    return (_jsxs(Modal, { "aria-labelledby": modalId, children: [_jsxs(ModalHeader, { children: [_jsx(ModalTitle, { id: modalId, children: t('VoIP_device_permission_required') }), _jsx(ModalClose, { "aria-label": t('Close'), onClick: onClose })] }), _jsx(ModalContent, { children: _jsx(Box, { is: 'span', className: breakSpaces, fontScale: 'p2', children: t('VoIP_device_permission_required_description', {
                        workspaceUrl: absoluteUrl(''),
                    }) }) }), _jsx(ModalFooter, { children: _jsx(ModalFooterControllers, { children: getFooter(type, { onCancel, onConfirm, onClose, t }) }) })] }));
};
export default PermissionFlowModal;
//# sourceMappingURL=PermissionFlowModal.js.map