var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { useDebouncedValue } from '@rocket.chat/fuselage-hooks';
import { keepPreviousData, useQuery } from '@tanstack/react-query';
import { createContext, useContext, useState } from 'react';
export const defaultMediaCallContextValue = {
    state: 'closed',
    connectionState: 'CONNECTED',
    peerInfo: undefined,
    transferredBy: undefined,
    hidden: false,
    muted: false,
    held: false,
    remoteMuted: false,
    remoteHeld: false,
    onMute: () => undefined,
    onHold: () => undefined,
    onDeviceChange: () => undefined,
    onForward: () => undefined,
    onTone: () => undefined,
    onEndCall: () => undefined,
    onCall: () => Promise.resolve(undefined),
    onAccept: () => Promise.resolve(undefined),
    onToggleWidget: () => undefined,
    onSelectPeer: () => undefined,
    getAutocompleteOptions: () => Promise.resolve([]),
    getPeerInfo: () => Promise.resolve(undefined),
};
const MediaCallContext = createContext(defaultMediaCallContextValue);
// This hook is for internal use only. It will only be available if the user has the necessary permissions and the workspace has the necessary modules.
export const useMediaCallContext = () => {
    const context = useContext(MediaCallContext);
    if (context.state === 'unauthorized') {
        throw new Error('MediaCallContext is unauthorized');
    }
    if (context.state === 'unlicensed') {
        throw new Error('MediaCallContext is unlicensed');
    }
    return context;
};
// This hook is for other modules/packages, and exposes the necessary properties to interact with the context.
export const useMediaCallExternalContext = () => {
    const context = useContext(MediaCallContext);
    if (context.state === 'unauthorized' || context.state === 'unlicensed') {
        return context;
    }
    return { state: context.state, onToggleWidget: context.onToggleWidget, onEndCall: context.onEndCall, peerInfo: context.peerInfo };
};
const PREFIX_FIRST_OPTION = 'rcx-first-option-';
export const isFirstPeerAutocompleteOption = (value) => {
    return value.startsWith(PREFIX_FIRST_OPTION);
};
const getFirstOption = (filter) => {
    return { value: `${PREFIX_FIRST_OPTION}${filter}`, label: filter, avatarUrl: '' };
};
export const usePeerAutocomplete = (onSelectPeer, peerInfo) => {
    const { getAutocompleteOptions } = useMediaCallContext();
    const [filter, setFilter] = useState('');
    const debouncedFilter = useDebouncedValue(filter, 400);
    const { data: options } = useQuery({
        queryKey: ['mediaCall/peerAutocomplete', debouncedFilter],
        queryFn: () => __awaiter(void 0, void 0, void 0, function* () {
            const options = yield getAutocompleteOptions(debouncedFilter);
            if (debouncedFilter.length > 0) {
                return [getFirstOption(debouncedFilter), ...options];
            }
            return options;
        }),
        placeholderData: keepPreviousData,
        initialData: [],
    });
    return {
        options,
        onChangeFilter: setFilter,
        onChangeValue: (value) => {
            if (Array.isArray(value)) {
                return;
            }
            if (isFirstPeerAutocompleteOption(value)) {
                onSelectPeer({ number: value.replace(PREFIX_FIRST_OPTION, '') });
                return;
            }
            const localInfo = options.find((option) => option.value === value);
            if (!localInfo) {
                throw new Error(`Peer info not found for value: ${value}`);
            }
            onSelectPeer({
                userId: localInfo.value,
                displayName: localInfo.label,
                avatarUrl: localInfo.avatarUrl,
                status: localInfo.status,
            });
        },
        value: peerInfo && 'userId' in peerInfo ? peerInfo.userId : undefined,
        filter,
        onKeypadPress: (key) => setFilter((filter) => filter + key),
    };
};
export default MediaCallContext;
//# sourceMappingURL=MediaCallContext.js.map