import { jsx as _jsx } from "react/jsx-runtime";
import { useMediaCallContext } from './MediaCallContext';
import { OngoingCall, NewCall, IncomingCall, OutgoingCall, IncomingCallTransfer, OutgoingCallTransfer } from './views';
const MediaCallWidget = () => {
    const { state, hidden, transferredBy } = useMediaCallContext();
    if (hidden) {
        return null;
    }
    switch (state) {
        case 'ongoing':
            return _jsx(OngoingCall, {});
        case 'new':
            return _jsx(NewCall, {});
        case 'ringing':
            if (transferredBy) {
                return _jsx(IncomingCallTransfer, {});
            }
            return _jsx(IncomingCall, {});
        case 'calling':
            if (transferredBy) {
                return _jsx(OutgoingCallTransfer, {});
            }
            return _jsx(OutgoingCall, {});
        case 'closed':
        default:
            return null;
    }
};
export default MediaCallWidget;
//# sourceMappingURL=MediaCallWidget.js.map